% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kaya.R
\name{plot_fuel_mix}
\alias{plot_fuel_mix}
\title{Plot fuel mix}
\usage{
plot_fuel_mix(fuel_mix, collapse_renewables = TRUE, title = NULL)
}
\arguments{
\item{fuel_mix}{A tibble with the mixture of fuels:
\describe{
  \item{fuel}{The name of the fuel}
  \item{quads}{The number of quads per year the country or region consumes}
  \item{frac}{The percentage of the country's energy that comes from that fuel}
}}

\item{collapse_renewables}{Combine hydroelectricity and other renewables into
a single category.}

\item{title}{Include a title on the plot. If `title` is `NULL` (default)
or `TRUE`, a default title is created from the names of the regions in
`fuel_mix`.
If `title` is a character string, that string is used.
If `title` is `FALSE`, the plot is produced with no title.}
}
\value{
A plot object.
}
\description{
Plot fuel mix
}
\examples{
usa_fuel <- get_fuel_mix("United States", collapse_renewables = FALSE)
plot_fuel_mix(usa_fuel)
plot_fuel_mix(usa_fuel, collapse_renewables = FALSE)

}
