% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.kdensity}
\alias{plot.kdensity}
\title{Plot Method for Kernel Density Estimation}
\usage{
\method{plot}{kdensity}(x, range = NULL, plot_start = FALSE,
  zero_line = TRUE, ...)
}
\arguments{
\item{x}{a \code{kdensity} object.}

\item{range}{range of x values.}

\item{plot_start}{logical; if \code{TRUE}, plots the parametric start instead of the kernel density estimate.}

\item{zero_line}{logical; if \code{TRUE}, add a base line at \code{y = 0}.}

\item{...}{further plotting parameters.}
}
\value{
None.
}
\description{
The \code{plot} method for \code{kdensity} objects.
}
\examples{
## Using the data set "precip" to eye-ball the similarity between
## a kernel fit, a parametric fit, and a kernel with parametric start fit.
kde_gamma = kdensity(precip, kernel = "gaussian", start = "gamma")
kde = kdensity(precip, kernel = "gaussian", start = "uniform")

plot(kde_gamma, main = "Annual Precipitation in US Cities")
lines(kde_gamma, plot_start = TRUE, lty = 2)
lines(kde, lty = 3)
rug(precip)
}
\seealso{
\code{\link{kdensity}}
}
