\name{kequate-package}
\alias{kequate-package}
\docType{package}
\title{
The Kernel Method of Test Equating
}
\description{
The kernel equating technique for equating test scores is implemented, supporting the Equivalent Groups (EG), Single Group (SG), Counterbalanced (CB), Non-Equivalent groups with Anchor Test Chain Equating (NEAT CE), Non-Equivalent groups with Anchor Test Post-Stratification Equating (NEAT PSE) and Non-Equivalent groups with Covariates (NEC) designs. Support for three types of kernels is provided: Gaussian, logistic and uniform. Standard errors of equating and standard errors of the difference between two equating functions are provided for all designs and kernels. Also included are functions aiding the search for a proper log-linear pre-smoothing model and the ability to use Item Response Theory Observed Score Equating (IRT-OSE) in the Kernel Equating framework.
}
\details{
\tabular{ll}{
Package: \tab kequate\cr
Type: \tab Package\cr
Version: \tab 1.6.0\cr
Date: \tab 2016-09-20\cr
License: \tab GPL-3\cr
LazyLoad: \tab yes\cr
Depends: \tab R (>=2.11.0), methods, graphics, stats, ltm\cr
}
}

\author{
Bjorn Andersson, Kenny Branberg and Marie Wiberg

Maintainer: Bjorn Andersson \email{bjoern.h.andersson@gmail.com}

}
\references{
Andersson, B., Branberg, K., Wiberg, M. (2013). Performing the Kernel Method of Test Equating with the Package \bold{kequate}. \emph{Journal of Statistical Software}, \bold{55(6)}, 1--25. URL \url{http://www.jstatsoft.org/v55/i06/}

Branberg, K., Wiberg, M. (2011). Observed Score Linear Equating with Covariates.  \emph{Journal of Educational Measurement}, \bold{44(4)}, 419--440. URL \url{http://dx.doi.org/10.1111/j.1745-3984.2011.00153.x}

von Davier, A.A., Holland, P.W., Thayer, D.T. (2004). \emph{The Kernel Method of Test Equating.} Springer-Verlag New York.

Holland, P.W,  Thayer, D. (1998). Univariate and Bivariate Loglinear Models for Discrete Test Score Distributions \emph{ETS Technical Report No} \bold{98-1}.
}

\keyword{package}