% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-embedding.R
\name{layer_embedding}
\alias{layer_embedding}
\title{Turns positive integers (indexes) into dense vectors of fixed size}
\usage{
layer_embedding(
  object,
  input_dim,
  output_dim,
  embeddings_initializer = "uniform",
  embeddings_regularizer = NULL,
  activity_regularizer = NULL,
  embeddings_constraint = NULL,
  mask_zero = FALSE,
  input_length = NULL,
  sparse = FALSE,
  ...
)
}
\arguments{
\item{object}{Layer or Model object}

\item{input_dim}{Integer. Size of the vocabulary,
i.e. maximum integer index + 1.}

\item{output_dim}{Integer. Dimension of the dense embedding.}

\item{embeddings_initializer}{Initializer for the \code{embeddings}
matrix (see \code{keras.initializers}).}

\item{embeddings_regularizer, activity_regularizer}{Regularizer function applied to
the \code{embeddings} matrix or to the activations (see \code{keras.regularizers}).}

\item{embeddings_constraint}{Constraint function applied to
the \code{embeddings} matrix (see \code{keras.constraints}).}

\item{mask_zero}{Boolean, whether or not the input value 0 is a special
"padding" value that should be masked out. This is useful when using
recurrent layers which may take variable length input. If this is
\code{TRUE}, then all subsequent layers in the model need to support masking
or an exception will be raised. If mask_zero is set to TRUE, as a
consequence, index 0 cannot be used in the vocabulary (input_dim should
equal size of vocabulary + 1).}

\item{input_length}{Length of input sequences, when it is constant.
This argument is required if you are going to connect
\code{Flatten} then \code{Dense} layers upstream
(without it, the shape of the dense outputs cannot be computed).}

\item{sparse}{If TRUE, calling this layer returns a \code{tf.SparseTensor}. If FALSE,
the layer returns a dense \code{tf.Tensor}. For an entry with no features in
a sparse tensor (entry with value 0), the embedding vector of index 0 is
returned by default.}

\item{...}{standard layer arguments.}
}
\description{
Turns positive integers (indexes) into dense vectors of fixed size
}
\details{
For example, \code{list(4L, 20L) -> list(c(0.25, 0.1), c(0.6, -0.2))}.

This layer can only be used on positive integer inputs of a fixed range. The
\code{layer_text_vectorization()}, \code{layer_string_lookup()},
and \code{layer_integer_lookup()} preprocessing layers can help prepare
inputs for an \code{Embedding} layer.

This layer accepts \code{tf.Tensor}, \code{tf.RaggedTensor} and \code{tf.SparseTensor}
input.
}
\section{Input shape}{
 2D tensor with shape: \verb{(batch_size, sequence_length)}.
}

\section{Output shape}{
 3D tensor with shape: \verb{(batch_size, sequence_length, output_dim)}.
}

\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Embedding}
\item \url{https://keras.io/api/layers}
}
}
