% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_keras}
\alias{install_keras}
\title{Install TensorFlow and Keras, including all Python dependencies}
\usage{
install_keras(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  tensorflow = version,
  extra_packages = NULL,
  ...
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary. See
\strong{Finding Conda} for more details.}

\item{version}{TensorFlow version to install. Valid values include:
\itemize{
\item \code{"default"} installs  2.6
\item \code{"release"} installs the latest release version of tensorflow (which may
be incompatible with the current version of the R package)
\item A version specification like \code{"2.4"} or \code{"2.4.0"}. Note that if the patch
version is not supplied, the latest patch release is installed (e.g.,
\code{"2.4"} today installs version "2.4.2")
\item \code{nightly} for the latest available nightly build.
\item To any specification, you can append "-cpu" to install the cpu version
only of the package (e.g., \code{"2.4-cpu"})
\item The full URL or path to a installer binary or python *.whl file.
}}

\item{tensorflow}{Synonym for \code{version}. Maintained for backwards.}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}, depending on the \code{method} used.}
}
\description{
This function will install Tensorflow and all Keras dependencies. This is a
thin wrapper around \code{\link[tensorflow:install_tensorflow]{tensorflow::install_tensorflow()}}, with the only
difference being that this includes by default additional extra packages that
keras expects, and the default version of tensorflow installed by
\code{install_keras()}  may at times be different from the default installed
\code{install_tensorflow()}. The default version of tensorflow installed by
\code{install_keras()} is "2.6".
}
\details{
The default additional packages are:
tensorflow-hub, scipy, requests, pyyaml, Pillow, h5py, pandas, with their
versions potentially constrained for compatibility with the
requested tensorflow version.
}
\section{Custom Installation}{

 \code{install_tensorflow()} or
\code{keras::install_keras()} isn't required to use tensorflow with the package.
If you manually configure a python environment with the required
dependencies, you can tell R to use it by pointing reticulate at it,
commonly by setting an environment variable:

\code{Sys.setenv("RETICULATE_PYTHON" = "~/path/to/python-env/bin/python")}

}

\section{Apple Silicon}{

 Tensorflow on Apple Silicon is not officially
supported by the tensorflow maintainers. It is known that there can be
issues running the official Tensorflow package under Rosetta as well.
Fortunately, for the time being Apple has published a custom version of
Tensorflow compatible with M1 macs. Installation instructions can be found
at: \url{https://developer.apple.com/metal/tensorflow-plugin/}. Please note
that this is an experimental build of both python and tensorflow. After
following the instructions provided by Apple, you can advise reticulate to
use that python installation by placing the following in your
\code{.Renviron} file:

\code{RETICULATE_PYTHON = "~/miniforge3/bin/python"}

}

\section{Additional Packages}{



If you wish to add additional PyPI packages to your Keras / TensorFlow
environment you can either specify the packages in the \code{extra_packages}
argument of \code{install_tensorflow()} or \code{install_keras()}, or alternatively
install them into an existing environment using the
\code{\link[reticulate:py_install]{reticulate::py_install()}} function. Note that \code{install_keras()} includes a
set of additional python packages by default, see \code{?keras::install_keras}
for details.

}

\seealso{
\code{\link[tensorflow:install_tensorflow]{tensorflow::install_tensorflow()}}
}
