% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{model_to_saved_model}
\alias{model_to_saved_model}
\title{Export to Saved Model format}
\usage{
model_to_saved_model(
  model,
  saved_model_path,
  custom_objects = NULL,
  as_text = FALSE,
  input_signature = NULL,
  serving_only = FALSE
)
}
\arguments{
\item{model}{A Keras model to be saved. If the model is subclassed, the flag
\code{serving_only} must be set to \code{TRUE}.}

\item{saved_model_path}{a string specifying the path to the SavedModel directory.}

\item{custom_objects}{Optional dictionary mapping string names to custom classes
or functions (e.g. custom loss functions).}

\item{as_text}{bool, \code{FALSE} by default. Whether to write the SavedModel proto in text
format. Currently unavailable in serving-only mode.}

\item{input_signature}{A possibly nested sequence of \code{tf.TensorSpec} objects, used to
specify the expected model inputs. See tf.function for more details.}

\item{serving_only}{bool, \code{FALSE} by default. When this is true, only the
prediction graph is saved.}
}
\value{
Invisibly returns the \code{saved_model_path}.
}
\description{
Export to Saved Model format
}
\note{
This functionality is experimental and only works with TensorFlow
version >= "2.0".
}
\seealso{
Other saved_model: 
\code{\link{model_from_saved_model}()}
}
\concept{saved_model}
