% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_1d}
\alias{layer_conv_1d}
\title{1D convolution layer (e.g. temporal convolution).}
\usage{
layer_conv_1d(
  object,
  filters,
  kernel_size,
  strides = 1L,
  padding = "valid",
  data_format = NULL,
  dilation_rate = 1L,
  groups = 1L,
  activation = NULL,
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  ...
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{filters}{int, the dimension of the output space (the number of filters
in the convolution).}

\item{kernel_size}{int or list of 1 integer, specifying the size of the
convolution window.}

\item{strides}{int or list of 1 integer, specifying the stride length
of the convolution. \code{strides > 1} is incompatible with
\code{dilation_rate > 1}.}

\item{padding}{string, \code{"valid"}, \code{"same"} or \code{"causal"}(case-insensitive).
\code{"valid"} means no padding. \code{"same"} results in padding evenly to
the left/right or up/down of the input. When \code{padding="same"} and
\code{strides=1}, the output has the same size as the input.
\code{"causal"} results in causal (dilated) convolutions, e.g. \code{output[t]}
does not depend on\code{tail(input, t+1)}. Useful when modeling temporal data
where the model should not violate the temporal order.
See \href{https://arxiv.org/abs/1609.03499}{WaveNet: A Generative Model for Raw Audio, section2.1}.}

\item{data_format}{string, either \code{"channels_last"} or \code{"channels_first"}.
The ordering of the dimensions in the inputs. \code{"channels_last"}
corresponds to inputs with shape \verb{(batch, steps, features)}
while \code{"channels_first"} corresponds to inputs with shape
\verb{(batch, features, steps)}. It defaults to the \code{image_data_format}
value found in your Keras config file at \verb{~/.keras/keras.json}.
If you never set it, then it will be \code{"channels_last"}.}

\item{dilation_rate}{int or list of 1 integers, specifying the dilation
rate to use for dilated convolution.}

\item{groups}{A positive int specifying the number of groups in which the
input is split along the channel axis. Each group is convolved
separately with \verb{filters // groups} filters. The output is the
concatenation of all the \code{groups} results along the channel axis.
Input channels and \code{filters} must both be divisible by \code{groups}.}

\item{activation}{Activation function. If \code{NULL}, no activation is applied.}

\item{use_bias}{bool, if \code{TRUE}, bias will be added to the output.}

\item{kernel_initializer}{Initializer for the convolution kernel. If \code{NULL},
the default initializer (\code{"glorot_uniform"}) will be used.}

\item{bias_initializer}{Initializer for the bias vector. If \code{NULL}, the
default initializer (\code{"zeros"}) will be used.}

\item{kernel_regularizer}{Optional regularizer for the convolution kernel.}

\item{bias_regularizer}{Optional regularizer for the bias vector.}

\item{activity_regularizer}{Optional regularizer function for the output.}

\item{kernel_constraint}{Optional projection function to be applied to the
kernel after being updated by an \code{Optimizer} (e.g. used to implement
norm constraints or value constraints for layer weights). The
function must take as input the unprojected variable and must return
the projected variable (which must have the same shape). Constraints
are not safe to use when doing asynchronous distributed training.}

\item{bias_constraint}{Optional projection function to be applied to the
bias after being updated by an \code{Optimizer}.}

\item{...}{For forward/backward compatability.}
}
\value{
A 3D tensor representing \code{activation(conv1d(inputs, kernel) + bias)}.
}
\description{
This layer creates a convolution kernel that is convolved with the layer
input over a single spatial (or temporal) dimension to produce a tensor of
outputs. If \code{use_bias} is \code{TRUE}, a bias vector is created and added to the
outputs. Finally, if \code{activation} is not \code{NULL}, it is applied to the
outputs as well.
}
\section{Input Shape}{
\itemize{
\item If \code{data_format="channels_last"}:
A 3D tensor with shape: \verb{(batch_shape, steps, channels)}
\item If \code{data_format="channels_first"}:
A 3D tensor with shape: \verb{(batch_shape, channels, steps)}
}
}

\section{Output Shape}{
\itemize{
\item If \code{data_format="channels_last"}:
A 3D tensor with shape: \verb{(batch_shape, new_steps, filters)}
\item If \code{data_format="channels_first"}:
A 3D tensor with shape: \verb{(batch_shape, filters, new_steps)}
}
}

\section{Raises}{
ValueError: when both \code{strides > 1} and \code{dilation_rate > 1}.
}

\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# The inputs are 128-length vectors with 10 timesteps, and the
# batch size is 4.
x <- random_uniform(c(4, 10, 128))
y <- x |> layer_conv_1d(32, 3, activation='relu')
shape(y)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## shape(4, 8, 32)

}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/convolution_layers/convolution1d#conv1d-class}
}

Other convolutional layers: \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{convolutional layers}
\concept{layers}
