% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped.R
\name{key-by-scoped}
\alias{key-by-scoped}
\alias{key_by_all}
\alias{key_by_if}
\alias{key_by_at}
\title{Key by selection of variables}
\usage{
key_by_all(.tbl, .funs = list(), ..., .add = FALSE, .exclude = FALSE)

key_by_if(.tbl, .predicate, .funs = list(), ..., .add = FALSE,
  .exclude = FALSE)

key_by_at(.tbl, .vars, .funs = list(), ..., .add = FALSE,
  .exclude = FALSE)
}
\arguments{
\item{.tbl}{Reference data frame .}

\item{.funs}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{...}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.add}{Whether to add keys to (possibly) existing ones. If \code{FALSE} keys
will be overridden.}

\item{.exclude}{Whether to exclude key variables from \code{.tbl}.}

\item{.predicate}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.vars}{Parameter for \link[dplyr:scoped]{scoped} functions.}
}
\description{
These functions perform keying by selection of variables using corresponding
\link[dplyr:select_all]{scoped variant} of \link[dplyr:select]{select}. Appropriate
data frame is selected with scoped function first, and then it is assigned
as keys.
}
\examples{
mtcars \%>\% key_by_all(.funs = toupper)

mtcars \%>\% key_by_if(rlang::is_integerish, toupper)

mtcars \%>\% key_by_at(c("vs", "am"), toupper)

}
\seealso{
\link[=keys-set]{Not scoped key_by()}
}
