% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{Get Metadata from a KHIS}
\usage{
get_metadata(
  endpoint,
  ...,
  fields = c("id", "name"),
  retry = 2,
  verbosity = 0,
  timeout = 60
)
}
\arguments{
\item{endpoint}{The KHIS API endpoint for the metadata of interest
(e.g. dataElements, organisationUnits).}

\item{...}{One or more \code{\link[=metadata_filter]{metadata_filter()}} params in key-value pairs.}

\item{fields}{The specific columns to be returned in the tibble.}

\item{retry}{Number of times to retry the API call in case of failure
(defaults to 2).}

\item{verbosity}{Level of HTTP information to print during the call:
\itemize{
\item 0: No output
\item 1: Show headers
\item 2: Show headers and bodies
\item 3: Show headers, bodies, and CURL status message.
}}

\item{timeout}{Maximum number of seconds to wait for the API response.}
}
\value{
A tibble with the KHIS metadata response.
}
\description{
\code{get_metadata} retrieves metadata for a specified endpoint of KHIS
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Get the categories metadata
get_metadata('categories')

# Get the datasets metadata with fields 'id,name,organisationUnits' and filter
# only the datasets with id 'WWh5hbCmvND'
get_metadata('dataSets',
             fields = 'id,name,organisationUnits[id,name,path]',
             id \%.eq\% 'WWh5hbCmvND')

# Get data elements filtered by dataElementgroups id
get_metadata('dataElements',
             dataElementGroups.id \%.eq\% 'IXd7DXxZqzL',
             fields = ':all')
\dontshow{\}) # examplesIf}
}
