% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_stats.R
\name{desc_stats}
\alias{desc_stats}
\title{Descriptive statistics}
\usage{
desc_stats(
  vector = NULL,
  output_type = "vector",
  sigfigs = 3,
  ci = TRUE,
  pi = TRUE,
  notify_na_count = NULL,
  print_dt = TRUE
)
}
\arguments{
\item{vector}{a numeric vector}

\item{output_type}{if \code{output_type = "vector"}, return a vector
of descriptive statistics; if \code{output_type = "dt"}, return a
data.table of descriptive statistics (default = "vector")}

\item{sigfigs}{number of significant digits to round to (default = 3)}

\item{ci}{logical. Should 95\% CI be included in the descriptive stats?
(default = TRUE)}

\item{pi}{logical. Should 95\% PI be included in the descriptive stats?
(default = TRUE)}

\item{notify_na_count}{if \code{TRUE}, notify how many observations
were removed due to missing values. By default, NA count will be printed
only if there are any NA values.}

\item{print_dt}{if \code{TRUE}, print the descriptive stats data.table}
}
\value{
if \code{output_type = "vector"}, the output will be a
named numeric vector of descriptive statistics;
if \code{output_type = "dt"}, the output will be data.table of
descriptive statistics.
}
\description{
Returns descriptive statistics for a numeric vector.
}
\examples{
desc_stats(1:100)
desc_stats(1:100, ci = TRUE, pi = TRUE, sigfigs = 2)
desc_stats(c(1:100, NA))
desc_stats(vector = c(1:100, NA), output_type = "dt")
}
