% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d.R
\name{cohen_d}
\alias{cohen_d}
\title{Calculate Cohen's d and its confidence interval using
the package 'psych'}
\usage{
cohen_d(
  sample_1 = NULL,
  sample_2 = NULL,
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  ci_range = 0.95,
  output_type = "all"
)
}
\arguments{
\item{sample_1}{a vector of values in the first of two samples}

\item{sample_2}{a vector of values in the second of two samples}

\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{ci_range}{range of the confidence interval for Cohen's d
(default = 0.95)}

\item{output_type}{If \code{output_type == "all"} or
if \code{output_type == "d_and_ci"}, the output will
be a vector of Cohen's d and its confidence interval.
If \code{output_type == "d"}, the output will be Cohen's d.
If \code{output_type == "ci"}, the output will be a vector
of the confidence interval around Cohen's d.
By default, \code{output_type == "all"}.}
}
\description{
To run this function, the following package(s) must be installed:
Package 'psych' v2.1.9 (or possibly a higher version) by
William Revelle (2021),
\url{https://cran.r-project.org/package=psych}
}
\examples{
\dontrun{
cohen_d(sample_1 = 1:10, sample_2 = 3:12)
cohen_d(data = mtcars, iv_name = "vs", dv_name = "mpg", ci_range = 0.99)
sample_dt <- data.table::data.table(iris)[Species != "setosa"]
cohen_d(data = sample_dt, iv_name = "Species", dv_name = "Petal.Width")
}
}
