% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass-graph-navigate.R
\name{is_combined}
\alias{is_combined}
\title{Given a graph and a node, determine if the node is a result of combinations
of multiple codes.}
\usage{
is_combined(graph, node, compare_node = NULL)
}
\arguments{
\item{graph}{A graph generated by \code{\link{klass_graph}}.}

\item{node}{A node as returned by \code{\link{klass_node}} or
\code{\link[igraph]{V}}.}

\item{compare_node}{Optional. A node to compare \code{node} with when
determining whether \code{node} is combined. See details.}
}
\value{
\code{TRUE} if the node is a combination of two or more nodes,
  otherwise \code{FALSE}.
}
\description{
Given a graph and a node, determine if the node is a result of combinations
of multiple codes.
}
\details{
The function will attempt to reconcile nodes that have split and
  then later merged again when evaluating a node's combinedness.

  If \code{compare_node == NULL}, a node is considered to be combined if more
  than one node that does not itself have a parent (i.e. codes at the start
  of a sequence of changes) contribute to \code{node}.

  If \code{compare_node != NULL}, a node is considered to be combined if any
  node that is not an ancestor of \code{compare_node} contributes to
  \code{node}, i.e. all paths from \code{node} to the parents of \code{node}
  pass through \code{compare_node}.
}
