% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmcudaR.R
\name{kmeans_cuda}
\alias{kmeans_cuda}
\title{K-Means Clustering using CUDA}
\usage{
kmeans_cuda(samples, clusters, tolerance = 0.01, init = "k-means++",
  yinyang_t = 0.1, metric = "L2", average_distance = FALSE, seed = NULL,
  device = 0L, verbosity = 0L)
}
\arguments{
\item{samples}{A numeric matrix}

\item{clusters}{the number of clusters}

\item{tolerance}{if the relative number of reassignments
drops below this value the algorithm stops}

\item{init}{A character vector or numeric matrix, sets the 
method for centroids initialization.  Options include 
"k-means++", "afk-mc2", "random" or numeric matrix of
shape [clusters, number of features]. Default = "kmeans++"}

\item{yinyang_t}{numeric value defining relative number of
cluster groups.  Usually 0.1 but 0 disables Yinyang refinement.}

\item{metric}{Character vector specifying distance metric to
use.  The default is Euclidean (L2), it can be changed to 
"cos" for Sphereical K-means with angular distance. NOTE - 
the samples must be normalized in the latter case.}

\item{average_distance}{logical indicating whether to calculate
the average distance between cluster elements and the
corresponding centroids.  Useful for finding the best 'K'.
Returned as third list element}

\item{seed}{random generator seed for reproducible results [deprecated]}

\item{device}{integer defining device to use. 1 = first device,
2 = second device, 3 = first & second devices, 0 = use all devices.
Default = 0}

\item{verbosity}{Integer indicating amount of output to see.
0 = silence, 1 = progress logging, 2 = all output}
}
\value{
a list consisting of
\item{centroids}{Cluster centroids}
\item{assignments}{integer vector of sample-cluster associations}
\item{average_distance}{average distance between cluster elements}
}
\description{
Performs k-means clustering on a
numeric matrix using a NVIDIA GPU via CUDA
}

