% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_latex_output}
\alias{is_latex_output}
\alias{is_html_output}
\title{Check if the current output type is LaTeX or HTML}
\usage{
is_latex_output()

is_html_output(fmt = pandoc_to(), excludes = NULL)
}
\arguments{
\item{fmt}{A character vector of output formats to be checked. By default, it
is the current Pandoc output format.}

\item{excludes}{A character vector of output formats that should not be
considered as the HTML format.}
}
\description{
The function \code{is_latex_output()} returns \code{TRUE} when the output
format is LaTeX; it works for both \file{.Rnw} and R Markdown documents (for
the latter, the two Pandoc formats \code{latex} and \code{beamer} are
considered LaTeX output). The function \code{is_html_output()} only works for
R Markdown documents.
}
\details{
These functions may be useful for conditional output that depends on the
output format. For example, you may write out a LaTeX table in an R Markdown
document when the output format is LaTeX, and an HTML or Markdown table when
the output format is HTML.

Internally, the Pandoc output format of the current R Markdown document is
stored in \code{knitr::\link{opts_knit}$get('rmarkdown.pandoc.to')}. By
default, these formats are considered as HTML formats: \code{c('markdown',
'epub', 'html', 'html5', 'revealjs', 's5', 'slideous', 'slidy')}.
}
\examples{
knitr::is_latex_output()
knitr::is_html_output()
knitr::is_html_output(excludes = c("markdown", "epub"))
}
