% Generated by roxygen2 (4.0.2): do not edit by hand
\name{knockoff.stat.lasso_difference}
\alias{knockoff.stat.lasso_difference}
\alias{knockoff.stat.lasso_signed_max}
\title{Knockoff filter lasso statistics}
\usage{
knockoff.stat.lasso_difference(X, X_ko, y, method = c("glmnet", "lars"))

knockoff.stat.lasso_signed_max(X, X_ko, y, method = c("glmnet", "lars"))
}
\arguments{
\item{X}{original design matrix}

\item{X_ko}{knockoff matrix}

\item{y}{response vector}

\item{method}{either 'glmnet' or 'lars'}
}
\value{
The statistic W
}
\description{
Computes the difference statistic
  \deqn{W_j = Z_j - \tilde{Z}_j}
or the signed maximum statistic
  \deqn{W_j = \max(Z_j, \tilde{Z}_j) \cdot \mathrm{sgn}(Z_j - \tilde{Z}_j),}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of
\eqn{\lambda} at which the jth variable and its knockoff, respectively,
enter the lasso model.
}
\details{
By default, the glmnet package is used.
}

