% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_01_kRp.tagged.R
\docType{class}
\name{kRp.tagged,-class}
\alias{kRp.tagged,-class}
\alias{kRp.tagged-class}
\title{S4 Class kRp.tagged}
\description{
This class is used for objects that are returned by \code{\link[koRpus:treetag]{treetag}} or \code{\link[koRpus:tokenize]{tokenize}}.
}
\section{Slots}{

\describe{
\item{\code{lang}}{A character string,
      naming the language that is assumed for the tokenized text in this object.}

\item{\code{desc}}{Descriptive statistics of the tagged text.}

\item{\code{TT.res}}{Results of the called tokenizer and POS tagger. The data.frame has eight columns:
\describe{
  \item{\code{token}:}{The tokenized text.}
  \item{\code{tag}:}{POS tags for each token.}
  \item{\code{lemma}:}{Lemma for each token.}
  \item{\code{lttr}:}{Number of letters.}
  \item{\code{wclass}:}{Word class.}
  \item{\code{desc}:}{A short description of the POS tag.}
  \item{\code{stop}:}{Logical, \code{TRUE} if token is a stopword.}
  \item{\code{stem}:}{Stemmed token.}
}}
}}

\note{
There is also \code{as()} methods to transform objects from other koRpus classes into kRp.tagged.
}
\keyword{classes}
