% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_auxiliary.R
\name{getswitch_chisq}
\alias{getswitch_chisq}
\title{Get switch result for tkonfound based on chi-square tests}
\usage{
getswitch_chisq(a, b, c, d, thr_p = 0.05, switch_trm = T)
}
\arguments{
\item{a}{cell is the number of cases in the control group showing unsuccessful results}

\item{b}{cell is the number of cases in the control group showing successful results}

\item{c}{cell is the number of cases in the treatment group showing unsuccessful results}

\item{d}{cell is the number of cases in the treatment group showing successful results}

\item{thr_p}{the p-value threshold used to evaluate statistical significance, with the default of 0.05}

\item{switch_trm}{whether switching the two cells in the treatment row or the two cells in the control row, with the default of the treatment row}
}
\value{
prints the results that are needed for tkonfound
}
\description{
This function serves for tkonfound
}
\examples{
# using getswitch_chisq for a 2x2 table
getswitch_chisq(35, 17, 17, 38)
getswitch_chisq(35, 17, 17, 38, thr_p = 0.01)
getswitch_chisq(35, 17, 17, 38, thr_p = 0.01, switch_trm = FALSE)
}
