% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkonfound.R
\name{mkonfound}
\alias{mkonfound}
\title{Meta-Analysis and Sensitivity Analysis for Multiple Studies}
\usage{
mkonfound(d, t, df, alpha = 0.05, tails = 2, return_plot = FALSE)
}
\arguments{
\item{d}{A data frame or tibble containing t-statistics and associated 
degrees of freedom.}

\item{t}{Column name or vector of t-statistics.}

\item{df}{Column name or vector of degrees of freedom associated 
with t-statistics.}

\item{alpha}{Significance level for hypothesis testing.}

\item{tails}{Number of tails for the test (1 or 2).}

\item{return_plot}{Whether to return a plot of the percent bias 
(default is `FALSE`).}
}
\value{
Depending on `return_plot`, either returns a data frame with 
analysis results or a plot.
}
\description{
Performs sensitivity analysis for multiple models, where parameters 
are stored in a data frame. It calculates the amount of bias required to 
invalidate or sustain an inference for each case in the data frame.
}
\examples{
\dontrun{
mkonfound_ex
str(d)
mkonfound(mkonfound_ex, t, df)
}
}
