% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelCItest.R
\name{kernelCItest}
\alias{kernelCItest}
\title{Kernel Conditional Independence test}
\usage{
kernelCItest(x, y, S = NULL, suffStat, verbose = FALSE, data,
  ic.method = NULL, p = NULL, index = NULL, sig = NULL, numCol = NULL,
  numCluster = NULL, eps = NULL, paral = NULL)
}
\arguments{
\item{x, y, S}{It is tested, whether x and y are conditionally independent given the subset S of the remaining nodes. x, y, S all are integers, corresponding to variable or node numbers.}

\item{suffStat}{a list of parameters consisting of data, ic.method, p, index, sig, numCol, numCluster, eps, paral}

\item{verbose}{a logical parameter, if TRUE, detailed output is provided.}

\item{data}{numeric matrix witch collumns representing variables and rows representing samples}

\item{ic.method}{Method for the (conditional) independence test: Distance Covariance (permutation or gamma test), HSIC (permutation or gamma test) or HSIC cluster}

\item{p}{Number of permutations for Distance Covariance, HSIC permutation and HSIC cluster tests. Default is Distance Covariance}

\item{index}{Number in (0,2] the power of the distance in the Distance Covariance}

\item{sig}{Gaussian kernel width for HSIC tests. Default is 1}

\item{numCol}{Number of columns used in the incomplete Cholesky decomposition. Default is 50}

\item{numCluster}{Number of clusters for kPC clust algorithm}

\item{eps}{Normalization parameter for kPC clust. Default is 0.1}

\item{paral}{Number of cores to use for parallel calculations.}
}
\value{
kernelCItest() returns the p-value of the test.
}
\description{
Test to check the (conditional) dependence between two variables x and y given a set of variables S, using independence criteria. The kernelCItest() function, uses Distance Covariance or Hilbert-Schmidt Independence Criterion to test for the (conditional) independence between random variables, with an interface that can easily by used in \code{\link{skeleton}}, \code{\link{pc}} or \code{\link{kpc}}.
}
\examples{
set.seed(10)
library(pcalg)
z <- 10*runif(300)
w <- 10*runif(300)
x <- sin(z) + runif(300)
y <- cos(z) + runif(300)

data <- cbind(x,y,z,w)

#conditionally independent
test1a <- kernelCItest(x=1,y=2,S=c(3),suffStat = list(data=data,ic.method="dcc.gamma"))
test2a <- kernelCItest(x=1,y=2,S=c(3),suffStat = list(data=data,ic.method="dcc.perm"))
test3a <- kernelCItest(x=1,y=2,S=c(3),suffStat = list(data=data,ic.method="hsic.gamma"))
test4a <- kernelCItest(x=1,y=2,S=c(3),suffStat = list(data=data,ic.method="hsic.perm"))
test5a <- kernelCItest(x=1,y=2,S=c(3),suffStat = list(data=data,ic.method="hsic.clust"))
test6a <- gaussCItest( x=1,y=2,S=c(3),suffStat = list(C=cor(data),n=4))

test1a
test2a
test3a
test4a
test5a
test6a

#dependent
test1b <- kernelCItest(x=1,y=2,S=c(4),suffStat = list(data=data,ic.method="dcc.gamma"))
test2b <- kernelCItest(x=1,y=2,S=c(4),suffStat = list(data=data,ic.method="dcc.perm"))
test3b <- kernelCItest(x=1,y=2,S=c(4),suffStat = list(data=data,ic.method="hsic.gamma"))
test4b <- kernelCItest(x=1,y=2,S=c(4),suffStat = list(data=data,ic.method="hsic.perm"))
test5b <- kernelCItest(x=1,y=2,S=c(4),suffStat = list(data=data,ic.method="hsic.clust"))
test6b <- gaussCItest( x=1,y=2,S=c(4),suffStat = list(C=cor(data),n=4))

test1b
test2b
test3b
test4b
test5b
test6b
}
\author{
Petras Verbyla (\email{petras.verbyla@mrc-bsu.cam.ac.uk}) and Nina Ines Bertille Desgranges
}
\references{
G. Szekely, M. Rizzo and N. Bakirov (2007). Measuring and Testing Dependence by Correlation of Distances. The Annals of Statistics 2007, Vol. 35, No. 6, 2769-2794.

A. Gretton et al. (2005). Kernel Methods for Measuring Independence. JMLR 6 (2005) 2075-2129.

R. Tillman, A. Gretton and P. Spirtes (2009). Nonlinear directed acyclic structure learning with weakly additive noise model. NIPS 22, Vancouver.
}

