% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyDiagnostic}
\alias{keyDiagnostic}
\title{Diagnose accuracy of result from applying variable key to data}
\usage{
keyDiagnostic(dfold, dfnew, keylist, max.values = 20, nametrunc = 8,
  wide = 200, confidential = FALSE)
}
\arguments{
\item{dfold}{Original data frame}

\item{dfnew}{The new recoded data frame}

\item{keylist}{The imported variable key that was used to
transform dfold into dfnew.}

\item{max.values}{Show up to this number of values for the old
variable}

\item{nametrunc}{Truncate column and row names. Needed if there
are long factor labels and we want to fit more information on
table. Default = 6.}

\item{wide}{Number of characters per row in printed
output. Suggest very wide screen, default = 200.}

\item{confidential}{Should numbers in table be rounded to nearest "10"
to comply with security standard enforced by some American research
departments.}
}
\description{
Compare the old and new data frames, checking for accuracy of
calculations in various ways.
}
\details{
The simplest thing is to crosstabulate new variable versus old variable to
see the mismatch.  For tables of up to 10 values or so, that will be satisfactory.

For numeric variables, it appears there is no good thing to do
except possibly to re-apply any transformations. Maybe a simple
scatterplot will suffice.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

