% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{shorten}
\alias{shorten}
\title{Reduce each in a vector of strings to a given length}
\usage{
shorten(x, k = 20, unique = FALSE)
}
\arguments{
\item{x}{character string}

\item{k}{integer limit on length of string. Default is 20}

\item{unique}{Default FALSE}
}
\value{
vector of character variables no longer than k
}
\description{
This is a simple "chop" at k characters, no fancy truncation at
spaces or such. Optionally, this will make unique the resulting
truncated strings. That way, truncation at character 4 of
"Washington" and "Wash" and "Washingham" will not result in 3
values of "Wash", but rather "Wash", "Wash.1", and "Wash.2"
}
\examples{
x <- c("Washington", "Washingham", "Washmylaundry")
shorten(x, 4)
shorten(x, 4, unique = TRUE)
}
\author{
Paul Johnson
}

