% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyDiff}
\alias{keyDiff}
\title{Compares a key provided to keyUpdate with the return of keyUpdate}
\usage{
keyDiff(oldkey, newkey)
}
\arguments{
\item{oldkey}{key that was provided to keyUpdate function}

\item{newkey}{updated key returned by keyUpdate function}
}
\value{
summary of differences between the two keys
}
\description{
Compares a key provided to keyUpdate with the return of keyUpdate
}
\examples{
library(rockchalk)
dat1 <- data.frame("Score" = c(1, 2, 3, 42, 4, 2),
                   "Gender" = c("M", "M", "M", "F", "F", "F"))
## First try with a long key
key1 <- keyTemplate(dat1, long = TRUE)
key1[5, "value_new"] <- 10
key1[6, "value_new"] <- "female"
key1[7, "value_new"] <- "male"
key1[key1$name_old == "Score", "name_new"] <- "NewScore"
dat2 <- data.frame("Score" = 7, "Gender" = "other", "Weight" = rnorm(3))
dat2 <- plyr::rbind.fill(dat1, dat2)
dat2 <- dat2[-1,]
key2 <- keyUpdate(key1, dat2, append = TRUE)
keyDiff(key1, key2)
}
\author{
Ben Kite <bakite@ku.edu>
}
