% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncsmart.R
\name{truncsmart}
\alias{truncsmart}
\title{Cuts a string at a specified linewidth, trying to align cut with a
separator}
\usage{
truncsmart(x, target = 20, tol = c(5, 3), separators = c(" ", "_",
  ";", ","), capwidth = 1)
}
\arguments{
\item{x}{character or vector of characters}

\item{target}{Goal for result length, in characters}

\item{tol}{number of characters forward/back to check; if single
value then only backwards checking}

\item{separators}{characters at which truncation is preferred,
such as space or underscore.}

\item{capwidth}{penalty for capital characters}
}
\value{
shorter string truncated at acceptable separators when
    found
}
\description{
Some strings are simply too long. We don't want to chop them
exactly at, say, 40 characters, if we could allow 42 and chop on a
space or other separator. We'd rather chop at 37 if there is a
separator, rather than terminate a word exactly at 40. This function
shortens them and attempt to cut at a separator, allowing for a
user specified fudge-factor (the tol parameter).
}
\details{
The default capwidth value is 1, so the calculations treat all
letters equally. In practice, we notice trouble when some strings
are written in ALL CAPS and they are longer than the same
information in lower case letters.  We have decided to allow a
user-specified penalty for capital letters. If each capital
counts for, say 1.2 ordinary letters, then we may end up truncating
the string on an earlier separator.

There's some approximation here. The capital-penalized widths are
calculated for all characters and then we left-shift the target
value so that it is equal to the last penalized value that is
under the target length. Then the "look to the left" and "look
to the right" logic begins.  That looking logic ignores the
capital letter penalty, it is treating all letters the same.
}
\examples{
x <- "Aasdf asdIasdf fW_asd asd aasjdf_as fasdasdfasdfasd"
truncsmart(x, target = 10, tol = c(5, 2))
truncsmart(x, target = 10, tol = c(1, 4))
truncsmart(x, target = 10, tol = c(5, 2), capwidth = 1.2)
truncsmart(x, target = 20, tol = c(5, 2))
truncsmart(x, target = 20, tol = c(10,10), capwidth = 2)
truncsmart(x, target = 20, tol = c(10,10), capwidth = 3)
truncsmart(x, target = 20, tol = c(10,10), capwidth = 4)
truncsmart(x, target = 20, tol = c(10,10), capwidth = 6)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
