% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverageprob.R
\name{coverageprob}
\alias{coverageprob}
\alias{coveragefrac}
\alias{cp}
\title{Estimate the coverage probability of a stationary RACS}
\usage{
coverageprob(xi, obswin = NULL)

coveragefrac(xi, obswin = NULL)

cp(xi, obswin = NULL)
}
\arguments{
\item{xi}{An observation of a RACS of interest as a full binary map (as an \code{im} object) or as the foreground set (as an \code{owin} object).
In the latter case the observation window, \code{obswin}, must be supplied.}

\item{obswin}{The window of observation (not necessarily rectangular) also as an \code{owin} object.}
}
\value{
An estimate of the coverage probability
}
\description{
Computes the proportion of the observation window that is foreground, which is the usual estimate for the coverage probability of a stationary RACS from a binary map.
}
\details{
The coverage probability of a stationary RACS is the probability that an arbitrary point is covered by the RACS.
Given a binary map, \code{xi}, of a realisation of stationary RACS \eqn{\Xi} in a window \eqn{W},
 this function computes the fraction of \eqn{W} covered by foreground,
which is an estimate of the coverage probability.
See (Chiu et al., 2013, Section 6.4.2) for more details.

If \code{xi} is an \code{im} object then \code{xi} must be an image of 1s, 0s and NAs
 representing inside the set, outside the set and outside the observation window respectively.
 \code{coverageprob} will not accept a \code{obswin} argument if \code{xi} is an \code{im} object.
}
\examples{
xi <- heather$coarse
obswindow <- Frame(heather$coarse)
cp <- coverageprob(xi, obswindow)
}
\references{
Chiu, S.N., Stoyan, D., Kendall, W.S. and Mecke, J. (2013) Stochastic Geometry and Its Applications, 3rd ed. Chichester, United Kingdom: John Wiley & Sons.
}
\author{
Kassel Liam Hingee
}
\keyword{nonparametric}
\keyword{spatial}
