% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rblnd.R
\name{rblnd}
\alias{rblnd}
\title{Simulate a Boolean model of discs with log normal disc radii}
\usage{
rblnd(obswin, bufferdist, lambda, meanlog, sdlog, seed = NULL)
}
\arguments{
\item{obswin}{An \code{owin} object specifying the desired simulation region}

\item{bufferdist}{A distance to expand \code{obswin} so that discs with centres near \code{obswin} are also simulated.}

\item{lambda}{Intensity of the Poisson point process, passed to \link[spatstat.core]{rpoispp}.
It could be either a single positive number, or any other object that \link[spatstat.core]{rpoispp} can understand.}

\item{meanlog}{For the distribution of radii. The logarithm of the distribution is set to have mean \code{meanlog}.}

\item{sdlog}{For the distribution of radii. The logarithm of the distribution is set to have standard deviation \code{sdlog}}

\item{seed}{Optional input (default is \code{NULL}). Is an integer passed to \code{\link[base]{set.seed}}. Used to reproduce patterns exactly.}
}
\value{
Returns an \code{owin} object cropped to \code{obswin}.
}
\description{
Simulates a Boolean model of discs with log normal radii by first simulating a Poisson point process and then placing discs
of random radii around each point (the radii are generated using a log normal distribution).
}
\details{
The point process needs to be simulated in a larger region than the desired observation window to account for the possibility of discs that intersect the observation window, but have germs outside the observation window.

The point process of germs is generated using spatstat's \code{\link[spatstat.core]{rpoispp}}.
}
\section{Warning}{
 A good choice of \code{bufferdist} is required and will be sensitive to the distribution of radii.
}

\examples{
w <- owin(xrange = c(0, 10), yrange = c(0, 10))
xi <- rblnd(w, 2, 0.3, -1, 0.2)
}
\keyword{datagen}
\keyword{spatial}
