% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_prd.R
\name{lsm_l_prd}
\alias{lsm_l_prd}
\title{PRD (landscape level)}
\usage{
lsm_l_prd(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch richness density (Diversity metric)
}
\details{
\deqn{PRD = \frac{m} {A} * 10000 * 100 }
where \eqn{m} is the number of classes and \eqn{A} is the total landscape area in
square meters.

PRD is a 'Diversity metric'. It is one of the simplest diversity and composition measures.
In contrast to \code{\link{lsm_l_pr}}, it is a relative measure and following, comparable
among landscapes with different total landscape areas.

\subsection{Units}{Number per 100 hectares}
\subsection{Range}{PR > 0}
\subsection{Behaviour}{Approaches PRD > 1 when only one patch is present and the landscape
is rather large. Increases, without limit, as the number of classes increases and the
total landscape area decreases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_prd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
