% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{prepare_extras}
\alias{prepare_extras}
\title{prepare_extras}
\usage{
prepare_extras(
  metrics,
  landscape_mat,
  directions,
  neighbourhood,
  ordered,
  base,
  resolution
)
}
\arguments{
\item{metrics}{A vector with metric abbreviations}

\item{landscape_mat}{A matrix object}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours: 4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered. Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured. The default is "log2",
which compute entropy in "bits". "log" and "log10" can be also used.}

\item{resolution}{A vector with two numbers (usually calculated using terra::res)}
}
\value{
A list with zero or more of the following components:
\itemize{
\item points: matrix with three columns: col, row, value
\item classes: vector with unique values
\item class_patches: list with matrices of patches for each class
\item area_patches: list with vectors of areas of patches for each class
\item composition_vector: vector with the number of cells for each class
\item neighbor_matrix: matrix with the number of cell pairs for each class
\item comp: entropy of the neighbor_matrix
\item cplx: complexity of the landscape
\item enn_patch: matrix with the euclidean nearest neighbour distance for each patch
}
}
\description{
Prepare an extras object
}
\details{
Wrapper around terra::xyFromCell and terra::getValues to get raster_to_points
function including NA values
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
prepare_extras("lsm_l_ent", landscape_mat, neighbourhood = 4, base = "log2")

\dontrun{
metrics = list_lsm()$function_name
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
prepare_extras(metrics, landscape_mat, directions = 8, neighbourhood = 4,
               ordered = FALSE, base = "log2", resolution = terra::res(landscape))
}

}
\seealso{
\code{\link{get_points}},
\code{\link{get_class_patches}},
\code{\link{get_area_patches}},
\code{\link{get_complexity}},
\code{\link{get_enn_patch}}
}
\keyword{internal}
