% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statusbar.R
\name{statusbar}
\alias{statusbar}
\title{Progressive Status Bar (Loading)}
\usage{
statusbar(
  run = 1,
  max.run = 100,
  label = run,
  msg = "",
  type = Sys.getenv("LARES_STATUSBAR"),
  start_time = NA,
  multiples = 1,
  alarm = FALSE
)
}
\arguments{
\item{run}{Iterator. for loop or an integer with the current loop number.
Start with 1 preferibly}

\item{max.run}{Number. Maximum number of loops}

\item{label}{String. With additionaly information to be printed
at the end of the line. The default is \code{run}.}

\item{msg}{Character. Finish message.}

\item{type}{Character. Loading type style: equal, domino}

\item{start_time}{POSIXct. Start time to consider. If NA, then
when first iteration starts will be set as start time. Useful
for when first iteration is showed as done but started a few
seconds/minutes ago.}

\item{multiples}{Integer. Only print when multiples of N (to avoid)
wasting resources on fast and lots of iterations.}

\item{alarm}{Boolean. Ping (sound) when done. Requires \code{beepr}.}
}
\value{
No return value, called for side effects.
}
\description{
This function lets the user view a progressbar for a 'for' loop.
}
\examples{
for (i in 1:9) {
  statusbar(i, 9, multiples = 2)
  Sys.sleep(0.3)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}
}
\concept{Tools}
