% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R, R/wrangling.R
\name{formatHTML}
\alias{formatHTML}
\alias{formatNum}
\title{Format a string text as markdown/HTML}
\usage{
formatHTML(text, color = "black", size = 20, bold = FALSE)

formatNum(
  x,
  decimals = 2,
  signif = NULL,
  type = Sys.getenv("LARES_NUMFORMAT"),
  pre = "",
  pos = "",
  sign = FALSE,
  abbr = FALSE,
  ...
)
}
\arguments{
\item{text}{Character. Strings to format.}

\item{color}{Character. Hex colour code.}

\item{size}{Numeric. Text size.}

\item{bold}{Boolean. Should the text be bold?}

\item{x}{Numerical Vector}

\item{decimals}{Integer. Amount of decimals to display. If set to
\code{NULL}, then \code{getOption("digits")} will be used.}

\item{signif}{Integer. Rounds the values in its first argument to
the specified number of significant digits.}

\item{type}{Integer. \code{1} for International standards. \code{2}
for American Standards. Use \code{Sys.setenv("LARES_NUMFORMAT" = 2)}
to set this parameter globally.}

\item{pre, pos}{Character. Add string before or after number.}

\item{sign}{Boolean. Add \code{+} sign to positive values.}

\item{abbr}{Boolean. Abbreviate using num_abbr()? You can use
the `decimals` parameter to set abbr's \code{n}(-1) parameter.}

\item{...}{Additional lazy eval parameters.}
}
\value{
String with format characters included.

Character. String vector with reformatted continuous numbers
}
\description{
Format any character string to HTML or markdown format. We
recommend using this format with the \code{ggtext::geom_richtext}
function to format text in \code{ggplot2} objects.

This function lets the user format numerical values nicely
}
\examples{
formatHTML("Text test", color = "#000000")
formatHTML(c(123, 456), color = "orange", size = 120, bold = TRUE)

# If you want to use it with \code{ggtext}:
\dontrun{
col1 <- "grey"
col2 <- "orange"
pt <- data.frame(
  label = paste0(
    formatHTML(123, color = col2, size = 120, bold = TRUE), "<br/>",
    formatHTML("of children had a", col1), "<br/>",
    formatHTML("traditional stay-at-home mom", color = col2, bold = TRUE), "<br/>",
    formatHTML(paste0("in 2012, compared to ", 321, " in 1970"), color = col1)
  )
)
ggplot(pt, aes(x = 0, y = 0)) +
  ggtext::geom_richtext(
    aes(label = label),
    hjust = 0,
    label.color = NA,
    lineheight = 1.5
  ) +
  xlim(0, 0.01) +
  theme_void()
}
formatNum(1.23456, decimals = 3)
formatNum(1.23456, type = 1)
formatNum(1.23456, pre = "$", pos = "/person")
formatNum(123456, abbr = TRUE)
formatNum(c(123123, 123.123, 0.123123), signif = 2)
formatNum(1234567890, abbr = TRUE, signif = 3)
formatNum(1234567890, decimals = 0, abbr = TRUE)
formatNum(c(-3:3), sign = TRUE)
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{dont_sleep}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}

Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
\concept{Tools}
