% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{postprob}
\alias{postprob}
\alias{postprob,lcModel-method}
\title{Posterior probability per fitted trajectory}
\usage{
\S4method{postprob}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel}.}

\item{...}{Additional arguments.}
}
\value{
A I-by-K \code{matrix} with \code{I = nIds(object)} and \code{K = nClusters(object)}.
}
\description{
Get the posterior probability matrix with element \eqn{(i,j)} indicating the probability of trajectory \eqn{i} belonging to cluster \eqn{j}.
}
\details{
This method should be extended by \code{lcModel} implementations. The default implementation returns uniform probabilities for all observations.
}
\section{Implementation}{

Classes extending \code{lcModel} should override this method.
\preformatted{
setMethod("postprob", "lcModelExt", function(object, ...) {
  # return trajectory-specific posterior probability matrix
})
}
}

\section{Troubleshooting}{

If you are getting errors about undefined model signatures when calling postprob(model),
check whether the postprob() function is still the one defined by the latrend package.
It may have been overridden when attaching another package (e.g., lcmm). If you need to attach conflicting packages, load them first.
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

postprob(model)

if (rlang::is_installed("lcmm")) {
  gmmMethod = lcMethodLcmmGMM(
    fixed = Y ~ Time,
    mixture = ~ Time,
    id = "Id",
    time = "Time"
  )
  gmmModel <- latrend(gmmMethod, data = latrendData)
  postprob(gmmModel)
}
}
\seealso{
\link{trajectoryAssignments} \link{predictPostprob} \link{predictAssignments}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
