% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addObservations.R
\name{addObservations}
\alias{addObservations}
\title{Input observations for use in the lattice-based density estimator}
\usage{
addObservations(formLatticeOutput, observations)
}
\arguments{
\item{formLatticeOutput}{An object returned by formLattice or
editLattice.}

\item{observations}{A matrix or data frame with two columns.}
}
\value{
a list with two elements.
\itemize{
\item{init_prob}{Numerical vector with the initial probability distribution}
\item{which_nodes}{vector of nodes to which observations were assigned}
}
}
\description{
This function takes a \code{formLatticeOutput} object, which encodes a region
possibly with and irregular boundary and holes, and adds point process
observations.  The observations should be in the form of a matrix or
data frame.  \code{addObservations} is used when the aim is to produce
a density map from a point process.  If, instead, you wish to produce
a nonparametric regression surface given responses and their locations, you
should use \code{addQuantVar} instead.
}
\details{
Every node in the \code{formLatticOutput} object is assigned an initial density
that is equal to the fraction of all observations that are nearest to that
node.  Note that this means observations can be outside the boundary of the
region of interest - they will just be associated with the nearest node inside
the region.  The function returns a vector equal in length to the number of
nodes that has the initial density for each node.  This vector corresponds to
\eqn{p_0}, the inital probability vector as in Barry and McIntyre (2011).
}
\examples{
plot.new()
data(polygon1)
#
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.01)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
#
Pointdata <- splancs::csr(polygon1,30)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
colnames(Pointdata) <- c("x","y")
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
#
densityOut <- createDensity(formLatticeOutput,PointPattern=Pointdata,
                           k=40,intensity=FALSE, sparse = TRUE)
plot(densityOut)
}
\references{
Ronald P. Barry, Julie McIntyre.  Estimating animal densities and home
range in regions with irregular boundaries and holes:  A lattice-based
alternative to the kernel density estimator.
Ecological Modelling 222 (2011)  1666-1672.
}
\author{
Ronald P. Barry
}
