% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExportFunctions.R
\name{save_png}
\alias{save_png}
\title{Saves a plot as a png}
\usage{
save_png(plot, path)
}
\arguments{
\item{plot}{plot object created by \code{lavaanPlot}}

\item{path}{Filename to save the image}
}
\value{
no return value saves plot as png
}
\description{
Saves a plot as a png
}
\examples{
library(lavaan)
model <- 'mpg ~ cyl + disp + hp
          qsec ~ disp + hp + wt'
fit <- sem(model, data = mtcars)
pl <- lavaanPlot(model = fit)
\dontrun{
save_png(pl, "plot.png")
}
}
