% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tesselate.R
\name{lawn_tesselate}
\alias{lawn_tesselate}
\title{Tesselate}
\usage{
lawn_tesselate(polygon, lint = FALSE)
}
\arguments{
\item{polygon}{input Polygon feaure}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a \code{\link{data-FeatureCollection}}
}
\description{
Tesselates a \code{\link{data-Polygon}} into a
\code{\link{data-FeatureCollection}} of
triangles using earcut (\url{https://github.com/mapbox/earcut})
}
\examples{
poly <- '{
 "type": "Feature",
  "properties": {
    "fill": "#0f0"
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-46.738586, -23.596711],
      [-46.738586, -23.458207],
      [-46.560058, -23.458207],
      [-46.560058, -23.596711],
      [-46.738586, -23.596711]
    ]]
  }
}'
lawn_tesselate(poly)

xx <- jsonlite::fromJSON(lawn_data$polygons_within, FALSE)
lawn_tesselate(xx$features[[1]])
}
\seealso{
Other assertions: \code{\link{lawn_circle}}
}

