% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tin.R
\name{lawn_tin}
\alias{lawn_tin}
\title{Create a Triangulated Irregular Network}
\usage{
lawn_tin(pt, propertyName = NULL, lint = FALSE)
}
\arguments{
\item{pt}{Input points.}

\item{propertyName}{(character) Name of the property from which to pull z
values. This is optional: if not given, then there will be no extra data
added to the derived triangles}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
TIN output, as a \link{data-FeatureCollection}.
}
\description{
Takes a set of \link{data-Point}'s and the name of a z-value property
and creates a Triangulated Irregular Network (TIN).
}
\details{
Data returned as a collection of Polygons. These are often used for
developing elevation contour maps or stepped heat visualizations.

This triangulates the points, as well as adds properties called a, b, and c
representing the value of the given propertyName at each of the points that
represent the corners of the triangle.
}
\examples{
pts <- lawn_random(bbox = c(-70, 40, -60, 60))
lawn_tin(pts)
\dontrun{
lawn_tin(pts) \%>\% view
lawn_tin(lawn_random(bbox = c(-70, 40, -60, 10))) \%>\% view
}
}
\seealso{
Other interpolation: \code{\link{lawn_hex_grid}},
  \code{\link{lawn_isolines}},
  \code{\link{lawn_planepoint}},
  \code{\link{lawn_point_grid}},
  \code{\link{lawn_square_grid}},
  \code{\link{lawn_triangle_grid}}
}
