% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/along.R
\name{lawn_along}
\alias{lawn_along}
\title{Get a point at a distance along a line}
\usage{
lawn_along(line, distance, units, lint = FALSE)
}
\arguments{
\item{line}{An input \link{data-LineString}.}

\item{distance}{Distance along the line.}

\item{units}{Units for the \code{distance} argument. Can be degrees, radians,
miles, or kilometers.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A \link{data-Point} distance units along the line.
}
\description{
Takes a \link{data-LineString} and returns a \link{data-Point}
at a specified distance along the line.
}
\examples{
pts <- '[
   [-21.964416, 64.148203],
   [-21.956176, 64.141316],
   [-21.93901, 64.135924],
   [-21.927337, 64.136673]
]'
lawn_along(lawn_linestring(pts), 1, 'miles')

line <- '{
"type": "Feature",
"properties": {},
"geometry": {
  "type": "LineString",
  "coordinates": [
    [-77.031669, 38.878605],
    [-77.029609, 38.881946],
    [-77.020339, 38.884084],
    [-77.025661, 38.885821],
    [-77.021884, 38.889563],
    [-77.019824, 38.892368]
    ]
 }
}'
lawn_along(line, distance = 1, units = 'miles')
\dontrun{
lawn_along(lawn_linestring(pts), 1, 'miles') \%>\% view
res <- lawn_along(lawn_linestring(pts), 1, 'miles')
lawn_featurecollection(list(res, lawn_linestring(pts))) \%>\% view
}
}
\seealso{
Other measurements: \code{\link{lawn_area}},
  \code{\link{lawn_bbox_polygon}}, \code{\link{lawn_bbox}},
  \code{\link{lawn_bearing}},
  \code{\link{lawn_center_of_mass}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_pt2line_distance}},
  \code{\link{lawn_square}}
}
\concept{measurements}
