% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy.build.R
\name{lazy.build}
\alias{lazy.build}
\title{Compile a PDF or HTML Report}
\usage{
lazy.build(filename, pdf.zip = NULL, quiet = TRUE, clean = TRUE,
  replace = TRUE, ...)
}
\arguments{
\item{filename}{Character string giving the location of the file to be built.
Usually a .tex or .html file.}

\item{pdf.zip}{filename where the completed document should be saved. Usually a 
.pdf or .zip file.}

\item{quiet}{Sets the system call flag for a quiet (non-verbose) run.}

\item{clean}{Sets the system call for cleaning up the folder after completion.
If \code{TRUE}, extra files generated during processing will be deleted.}

\item{replace}{when \code{pdf.zip} is not \code{NULL}, this determines if 
the new file will overwrite an existing file.}

\item{...}{Additoinal arguments to be passed to \code{tools::texi2dvi}}
}
\description{
Executes a command to build a pdf file based on a .tex or 
  .html file.  For HTML files, compiles the figure into a subfolder 
  and places all of the contents into a zip file
}
\details{
For TEX files, a call is made using \code{tools::texi2dvi} to 
  compile a PDF file.
  
  For HTML files, the referenced figures are gathered, copied into a
  subdirectory and the HTML document and the figures are placed into a 
  zip folder for convenient transfer.  All of the image links in the HTML
  code are modified to reflect the new location.  Lastly, a text file 
  is added with instructions for unzipping the files for convenient viewing
  (but don't worry, no one ever reads this).
}
\author{
Benjamin Nutter
}
