% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_macroeconomic_event.R
\name{evaluate_macroeconomic_event}
\alias{evaluate_macroeconomic_event}
\title{Function used to evaluate market type situation by reading the file with Macroeconomic Events}
\usage{
evaluate_macroeconomic_event(setup_path, file_name, path_t1, path_t3)
}
\arguments{
\item{setup_path}{Path with trading robots magic numbers setup, typically file 'Setup.csv'}

\item{file_name}{Name of the file}

\item{path_t1}{Path of the Terminal 1}

\item{path_t3}{Path of the Terminal 3}
}
\value{
Function will write files indicating to enable or disable trading systems to open new orders
}
\description{
Function is reading the content of the file 01_MacroeconomicEvent.csv.
Should the content of the file is 1 then Macro Economic event is present,
all trading robots will not be able to open new orders
}
\details{
This function is used exclusively with Market Type recognition system
}
\examples{

\donttest{

# evaluate data on macroeconomic event (required to start trading)
evaluate_macroeconomic_event(setup_path = setup_path,
                             file_name = "01_MacroeconomicEvent.csv",
                             path_t1 = path_T1,path_t3 = path_T3)

}


}
