% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts.R
\name{LDDMM}
\alias{LDDMM}
\title{Drift Diffusion Model Fit}
\usage{
LDDMM(
  data,
  hypers,
  boundaries = "flexible",
  Niter = 5000,
  burnin = 2000,
  thin = 5
)
}
\arguments{
\item{data}{dataframe with the following columns:
\itemize{
\item subject: vector of size n containing the participant labels
\item block: vector of size n containing the training blocks (longitudinal units)
\item s: vector of size n containing the stimuli
\item d: vector of size n containing the decisions
\item r_time: vector of size n containing the response times. To avoid numerical
issues, the unit of measurement should be such that the numerical
values of most response times should lie between 0 and 10
\item cens: vector of size n containing the censoring indicators (1 censored, 0 non censored)
}}

\item{hypers}{hyperparameters of the MCMC: list containing "s_sigma_mu" and "s_sigma_b",
which are the smoothness parameters for drifts and boundaries, respectively)}

\item{boundaries}{whether to fit the unrestricted model (flexible), assume constant
boundaries over time (constant) or fix the boundaries to the same level
across predictors (fixed)}

\item{Niter}{total number of iterations}

\item{burnin}{burnin of the chain}

\item{thin}{thinning factor}
}
\value{
List with the following MCMC posterior samples:
\itemize{
\item post_mean_delta: posterior samples for the population offset parameters
\item post_mean_mu: posterior samples for the population drift parameters
\item post_mean_b: posterior samples for the population boundary parameters
\item post_ind_delta: posterior samples for the individual offset parameters
\item post_ind_mu: posterior samples for the individual drift parameters
\item post_ind_b: posterior samples for the individual boundary parameters
\item sigma2_mu_us: posterior samples for the random effects drift smoothness parameters
\item sigma2_mu_ua: posterior samples for the random effects drift variance parameters
\item sigma2_b_us: posterior samples for the random effects boundary smoothness parameters
\item sigma2_b_ua: posterior samples for the random effects boundary variance parameters
\item sigma2_1_mu: posterior samples for the drift smoothness parameters
\item sigma2_1_b: posterior samples for the boundary smoothness parameters
\item pred_ans: predicted population-level categories
\item pred_time: predicted population-level response times
\item pred_ans_ind: predicted individual-level categories
\item pred_time_ind: predicted individual-level response times
}
}
\description{
Main function for the Gibbs sampler for the drift-diffusion model. Note that
priors are noninformative and calibrated so that, for the most stable
performance, the response times (variable \code{r_time} in the \code{data} dataframe)
should lie between 0 and 10.
}
