% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-pseudo_residuals.R
\name{ldhmm.pseudo_residuals}
\alias{ldhmm.pseudo_residuals}
\title{Computing pseudo-residuals}
\usage{
ldhmm.pseudo_residuals(object, x, xc.length = 1000)
}
\arguments{
\item{object}{an ldhmm object}

\item{x}{numeric, the observations.}

\item{xc.length}{a positive integer specifying the length of \code{xc} 
when calculating conditional probabilities, default is 1000.}
}
\value{
a vector of normal quantiles
}
\description{
This utility computes  pseudo-residuals. (Zucchini, 6.2)
}
\examples{
\dontrun{
  sr <- ldhmm.pseudo_residuals(object, x)
  hist(sr)
  acf(sr)
  qqnorm(sr, cex=0.5)
  L <- seq(-3,3,length.out=100)
  lines(L,L,col="red",lwd=2, lty=2)
}
}
\author{
Stephen H. Lihn
}
\keyword{residuals}

