% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-decode_stats_history.R
\name{ldhmm.decode_stats_history}
\alias{ldhmm.decode_stats_history}
\title{Estimating historical statistics (mean, volatility and kurtosis)}
\usage{
ldhmm.decode_stats_history(object, ma.order = 0, annualize = FALSE,
  days.pa = 252)
}
\arguments{
\item{object}{a decoded ldhmm object}

\item{ma.order}{a positive integer or zero, specifying order of moving average. Default is zero.}

\item{annualize}{logical, to annaulize the sd and mean to V (xsqrt(days.pa)x100) and R (xdays.pa). 
Default is \code{FALSE}.}

\item{days.pa}{a positive integer, specifying number of days per year, default is 252.}
}
\value{
an matrix of statistics history, size of observations times size of 3
}
\description{
This utility estimates historical statistics (mean, volatility and kurtosis) according to the state probabilities.
The ldhmm object must have been decoded by running through \code{ldhmm.decoding} function.
Note that kurtosis is naively implemented as the linear sum from each state weighted by state probabilities.
It is subject to change to more rigorous formula in future releases.
}
\author{
Stephen H. Lihn
}
\keyword{forecast}
