% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-n2w.R
\name{ldhmm.n2w}
\alias{ldhmm.n2w}
\title{Transforming natural parameters to a linear working parameter array}
\usage{
ldhmm.n2w(object, mu.scale = 1)
}
\arguments{
\item{object}{an ldhmm object}

\item{mu.scale}{numeric, if provided, e.g. \code{mean(abs(x))}, 
it is used to scale up mu so that the scale is more friendly to the optimizer.
Default is 1.}
}
\value{
numeric, linear working parameter array
}
\description{
This utility linearizes the natural parameters and transforms the contrained parameters
to unconstrained parameters. (Zucchini, 3.3.1)
}
\examples{
param0 <- matrix(c(0.003, 0.02, 1, -0.006, 0.03, 1.3), 2, 3, byrow=TRUE)
gamma0 <- matrix(c(0.9, 0.1, 0.1, 0.9), 2, 2, byrow=TRUE)
d <- ldhmm(m=2, param=param0, gamma=gamma0)
v <- ldhmm.n2w(d)

}
\author{
Stephen H. Lihn
}
\keyword{parameter}
