% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ClusterHGroup}
\alias{ClusterHGroup}
\title{Groups Variables with Hierarchical Clustering}
\usage{
ClusterHGroup(
  data,
  nGroups = 2L,
  threshold = 0,
  distance = "correlation",
  linkage = "single",
  correlation = "pearson"
)
}
\arguments{
\item{data}{(numeric matrix) Data with variables in the columns.}

\item{nGroups}{(int) Number of groups}

\item{threshold}{(double) A threshold for omitting variables. If distance between two variables in a group is less than this value, the second one will be omitted. Note that a change in the order of the columns might change the results.}

\item{distance}{(string)  Determines how distances are calculated. It can be \code{correlation}, \code{absCorrelation}, \code{euclidean}, \code{manhattan}, \code{maximum}.}

\item{linkage}{(string) Determines how Distances are calculated in a left-right node merge. It can be \code{single}, \code{complete}, \code{uAverage}, \code{wAverage}, \code{ward}.}

\item{correlation}{(string) If \code{distance} is correlation, it determines the type of the correlation. It can be \code{pearson}, \code{spearman}.}
}
\value{
A list:
\item{groups}{(List of integer vectors) indexes of variables in each group.}
\item{removed}{(integer vector) indexes of removed variables.}
}
\description{
Groups Variables with Hierarchical Clustering
}
\details{
The results might be different from R's 'cutree' function. I don't know how 'cutree' works, but here I iterate over the nodes and whenever a split occurs, I add a group until the required number of groups is reached.
}
