% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.combine.by.moments4}
\alias{s.combine.by.moments4}
\title{Combine Two Distributions Given their First 4 Moments}
\usage{
s.combine.by.moments4(mix1, mix2)
}
\arguments{
\item{mix1}{A list representing the first distribution with elements \code{mean}, \code{variance}, \code{skewness}, \code{kurtosis}, \code{sumWeights}, and \code{count}.}

\item{mix2}{A list representing the second distribution (similar to \code{mix1}).}
}
\value{
A list similar to \code{mix1}.
}
\description{
This function combines two distributions and calculates the first 4 moments of the combined distribution.
}
\details{
Let \code{A} and \code{B} be two distributions. By combining these two distributions we mean
if we get a sample of size \code{n} from both distributions and the combined distribution,
the first four moments of the combined samples equals the first four moments of the
sample from the combined distribution, as \code{n} goes to infinity.
}
\examples{
n <- 1000 # sample size (increase it for more accurate result)
sample1 <- rchisq(n,3)
sample2 <- rchisq(n,5)

d1 <- list(mean = mean(sample1),
           variance = var(sample1),
           skewness = moments::skewness(sample1),
           kurtosis = moments::kurtosis(sample1),
           count=length(sample1),
           sumWeights = length(sample1))
d2 <- list(mean = mean(sample2),
           variance = var(sample2),
           skewness = moments::skewness(sample2),
           kurtosis = moments::kurtosis(sample2),
           count=length(sample2),
           sumWeights = length(sample2))
c <- s.combine.by.moments4(d1,d2)

# we can compare the results:
combined <- c(sample1,sample2)
mean_c = mean(combined)
variance_c = var(combined)
skewness_c = moments::skewness(combined)
kurtosis_c = moments::kurtosis(combined)

}
