% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{addFgb}
\alias{addFgb}
\title{Add a flatgeobuf file to leaflet map}
\usage{
addFgb(
  map,
  file = NULL,
  url = NULL,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  label = NULL,
  radius = 10,
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = TRUE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  options = NULL
)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{file}{file path to the .fgb file to be added to \code{map}.
If set, \code{url} is ignored.}

\item{url}{url of the data to be added to \code{map}. Only respected if
\code{file = NULL}.}

\item{layerId}{the layer id.}

\item{group}{the group name for the file to be added to \code{map}.}

\item{popup}{either a logical of whether to show the feature properties
(fields) in popups or the name of the field to show in popups.}

\item{label}{name of the field to be shown as a tooltip.}

\item{radius}{the size of the circle markers.}

\item{stroke}{whether to draw stroke along the path
(e.g. the borders of polygons or circles).}

\item{color}{stroke color.}

\item{weight}{stroke width in pixels.}

\item{opacity}{stroke opacity.}

\item{fill}{whether to fill the path with color
(e.g. filling on polygons or circles).}

\item{fillColor}{fill color.}

\item{fillOpacity}{fill opacity.}

\item{dashArray}{a string that defines the stroke dash pattern.}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements.}
}
\description{
flatgeobuf is a performant binary geo-spatial file format suitable for
  serving large data. For more details see
  \url{https://github.com/bjornharrtell/flatgeobuf} and the respective
  documentation for the GDAL/OGR driver at
  \url{https://gdal.org/drivers/vector/flatgeobuf.html}. \cr
  \cr
  In contrast to classical ways of serving data from R onto a leaflet map,
  flatgeobuf will stream the data chunk by chunk so that rendering of the map
  is more or less instantaneous. The map is responsive while data is still
  being streamed so that popup queries, zooming and panning will work even
  though not all data has been rendered yet. This makes for a rather pleasant
  user experience as we don't have to wait for all data to be added to the map
  before interacting with it.
}
\examples{
 if (interactive()) {
   library(leaflet)
   library(leafem)

   # via URL
   url = "https://raw.githubusercontent.com/bjornharrtell/flatgeobuf/3.0.1/test/data/UScounties.fgb"

   leaflet() \%>\%
     addTiles() \%>\%
     leafem:::addFgb(
       url = url
       , group = "counties"
       , label = "NAME"
       , popup = TRUE
       , fillColor = "blue"
       , fillOpacity = 0.6
       , color = "black"
       , weight = 1
     ) \%>\%
       addLayersControl(overlayGroups = c("counties")) \%>\%
       addMouseCoordinates() \%>\%
       setView(lng = -105.644, lat = 51.618, zoom = 3)
 }

}
