% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{addFeatures}
\alias{addFeatures}
\title{Type agnositc version of \code{leaflet::add*} functions.}
\usage{
addFeatures(map, data, pane = "overlayPane", ...)
}
\arguments{
\item{map}{A \code{leaflet} or \code{mapview} map.}

\item{data}{A \code{sf} object to be added to the \code{map}.}

\item{pane}{The name of the map pane for the features to be rendered in.}

\item{...}{Further arguments passed to the respective \code{leaflet::add*}
functions. See \code{\link{addCircleMarkers}}, \code{\link{addPolylines}}
and \code{\link{addPolygons}}.}
}
\value{
A leaflet \code{map} object.
}
\description{
Add simple features geometries from \code{\link[sf]{sf}}
}
\examples{
library(leaflet)

leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addCircleMarkers(data = breweries91)
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addFeatures(data = breweries91)

leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addPolylines(data = atlStorms2005)
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addFeatures(atlStorms2005)

leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addPolygons(data = gadmCHE)
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addFeatures(gadmCHE)

}
