% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{addDrawToolbar}
\alias{addDrawToolbar}
\alias{removeDrawToolbar}
\title{Adds a Toolbar to draw shapes/points on the map.}
\usage{
addDrawToolbar(
  map,
  targetLayerId = NULL,
  targetGroup = NULL,
  position = c("topleft", "topright", "bottomleft", "bottomright"),
  polylineOptions = drawPolylineOptions(),
  polygonOptions = drawPolygonOptions(),
  circleOptions = drawCircleOptions(),
  rectangleOptions = drawRectangleOptions(),
  markerOptions = drawMarkerOptions(),
  circleMarkerOptions = drawCircleMarkerOptions(),
  editOptions = FALSE,
  singleFeature = FALSE,
  toolbar = NULL,
  handlers = NULL,
  drag = TRUE
)

removeDrawToolbar(map, clearFeatures = FALSE)
}
\arguments{
\item{map}{The map widget.}

\item{targetLayerId}{An optional layerId of a GeoJSON/TopoJSON layer whose features need to be editable.
Used for adding  a GeoJSON/TopoJSON layer and then editing the features using the draw plugin.}

\item{targetGroup}{An optional group name of a Feature Group whose features need to be editable.
Used for adding shapes(markers, lines, polygons) and then editing them using the draw plugin.
You can either set layerId or group or none but not both.}

\item{position}{The position where the toolbar should appear.}

\item{polylineOptions}{See \code{\link{drawPolylineOptions}}(). Set to FALSE to disable polyline drawing.}

\item{polygonOptions}{See \code{\link{drawPolygonOptions}}(). Set to FALSE to disable polygon drawing.}

\item{circleOptions}{See \code{\link{drawCircleOptions}}(). Set to FALSE to disable circle drawing.}

\item{rectangleOptions}{See \code{\link{drawRectangleOptions}}(). Set to FALSE to disable rectangle drawing.}

\item{markerOptions}{See \code{\link{drawMarkerOptions}}(). Set to FALSE to disable marker drawing.}

\item{circleMarkerOptions}{See \code{\link{drawCircleMarkerOptions}}(). Set to FALSE to disable circle marker drawing.}

\item{editOptions}{By default editing is disable. To enable editing pass \code{\link{editToolbarOptions}}().}

\item{singleFeature}{When set to TRUE, only one feature can be drawn at a time, the previous ones being removed.}

\item{toolbar}{See \code{\link{toolbarOptions}}. Set to \code{NULL} to take Leaflets default values.}

\item{handlers}{See \code{\link{handlersOptions}}. Set to \code{NULL} to take Leaflets default values.}

\item{drag}{When set to \code{TRUE}, the drawn features will be draggable during editing, utilizing
the \code{Leaflet.Draw.Drag} plugin. Otherwise, this library will not be included.}

\item{clearFeatures}{whether to clear the map of drawn features.}
}
\description{
Adds a Toolbar to draw shapes/points on the map.

Removes the draw toolbar
}
\details{
The drawn features emit events upon mouse interaction.
Event names follow the pattern: \code{input$MAPID_LAYERCATEGORY_EVENTNAME},
where \code{LAYERCATEGORY} can be one of:
\itemize{
  \item \code{marker}
  \item \code{shape}
  \item \code{polyline}
}

Similarly, for \code{EVENTNAME}, valid values are:
\itemize{
  \item \code{click}
  \item \code{mouseover}
  \item \code{mouseout}
}

See the provided example for usage:

\code{browseURL(system.file("examples/shiny/draw-events/draw_mouse_events.R",
                            package = "leaflet.extras"))}
}
\examples{
leaflet() \%>\%
  setView(0, 0, 2) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addDrawToolbar(
    targetGroup = "draw",
    editOptions = editToolbarOptions(
      selectedPathOptions = selectedPathOptions()
    )
  ) \%>\%
  addLayersControl(
    overlayGroups = c("draw"),
    options = layersControlOptions(collapsed = FALSE)
  ) \%>\%
  addStyleEditor()

## for more examples see
# browseURL(system.file("examples/draw.R",
#                       package = "leaflet.extras"))
# browseURL(system.file("examples/shiny/draw-events/app.R",
#                       package = "leaflet.extras"))
# browseURL(system.file("examples/shiny/draw-events/draw_mouse_events.R",
#                       package = "leaflet.extras"))
}
