% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popup_args.R
\name{popupArgs}
\alias{popupArgs}
\title{Options for popup generation}
\usage{
popupArgs(
  showTitle = TRUE,
  showValues = TRUE,
  labels = NULL,
  supValues = NULL,
  supLabels = colnames(supValues),
  html = NULL,
  noPopup = FALSE,
  digits = NULL
)
}
\arguments{
\item{showTitle}{If \code{TRUE} layer id is displayed as title of
popups.}

\item{showValues}{If \code{TRUE}, values are displayed in popups}

\item{labels}{Names of values. If \code{NULL}, column names of the data bound
to a chart are used.}

\item{supValues}{A \code{data.frame} containing additional values to display
in popups.}

\item{supLabels}{Names of the additional values.}

\item{html}{Character vector containing custom html code for popups. You can
use this parameter when you are not happy with the default popups.}

\item{noPopup}{If \code{TRUE}, popups are not created.}

\item{digits}{Max number of decimal digits to display for numeric values. If
\code{NULL}, all digits are displayed.}
}
\value{
List containing options for popup generation
}
\description{
This function simply returns a list of options to control the generation of
popups.
}
