% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_feature_cs.R
\name{create_feature_cs}
\alias{create_feature_cs}
\title{create_feature_cs}
\usage{
create_feature_cs(raster, locations, x, neighbours = 16)
}
\arguments{
\item{raster}{\code{RasterLayer} (raster package). This is used to derive the resolution, extent, and spatial reference system to be used when calculating the landscape feature cost surface}

\item{locations}{\code{SpatialPoints}. Locations of landscape features}

\item{x}{\code{numeric vector} of values denoting the attraction/repulsion from the landscape features}

\item{neighbours}{Number of directions used in the Least Cost Path calculation. See Huber and Church (1985) for methodological considerations when choosing number of neighbours. Expected values are 4, 8, or 16. Default is 16.}
}
\value{
\code{TransitionLayer} (gdistance package) numerically expressing the attraction/repulsion of a feature in the landscape. The resultant \code{TransitionLayer} can be incorporated with other \code{TransitionLayer} through Raster calculations.
}
\description{
Creates a Landscape Feature Cost Surface
}
\details{
Creates a cost surface representing the attraction/repulsion of a feature in the landscape. See Llobera (2000) for theoretical discussion in its application.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))
loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

num <- seq(200, 1, length.out = 20)

feature <- create_feature_cs(raster = r, locations = loc1, x = num)
}
\author{
Joseph Lewis
}
