% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lcp_network.R
\name{create_lcp_network}
\alias{create_lcp_network}
\title{create_lcp_network}
\usage{
create_lcp_network(
  cost_surface,
  locations,
  nb_matrix = NULL,
  cost_distance = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} object (gdistance package). Cost surface to be used in Least Cost Path calculation.}

\item{locations}{\code{SpatialPoints}. Potential locations to calculate Least Cost Paths from and to.}

\item{nb_matrix}{\code{matrix}. 2 column matrix representing the index of origins and destinations to calculate least cost paths between.}

\item{cost_distance}{if TRUE computes total accumulated cost for each Least Cost Path. Default is FALSE.}

\item{parallel}{if TRUE, the Least Cost Paths will be calculated in parallel. Number of Parallel socket clusters is total number of cores available minus 1. Default is FALSE.}
}
\value{
\code{SpatialLinesDataFrame} (sp package). The resultant object contains least cost paths calculated from each origins and destinations as specified in the neighbour matrix.
}
\description{
Calculates least cost paths from origins and destinations
}
\details{
Computes least cost paths from each origins and destinations as specified in the neighbour matrix.
}
\examples{

r <- raster::raster(nrow=50, ncol=50,  xmn=0, xmx=50, ymn=0, ymx=50,
crs='+proj=utm')

r[] <- stats::runif(1:length(r))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

locs <- sp::spsample(as(raster::extent(r), 'SpatialPolygons'),n=5,'regular')

lcp_network <- create_lcp_network(slope_cs, locations = locs,
nb_matrix = cbind(c(1, 4, 2, 1), c(2, 2, 4, 3)), cost_distance = FALSE, parallel = FALSE)
}
\author{
Joseph Lewis
}
