% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_wide_lcp.R
\name{create_wide_lcp}
\alias{create_wide_lcp}
\title{Calculate wide least cost path}
\usage{
create_wide_lcp(
  cost_surface,
  origin,
  destination,
  neighbours = 16,
  path_ncells
)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} (gdistance package). Cost surface to be used in Least Cost Path calculation}

\item{origin}{\code{SpatialPoints*} (sp package) location from which the Least Cost Path is calculated. Only the first row is taken into account}

\item{destination}{\code{SpatialPoints*} (sp package) location to which the Least Cost Path is calculated. Only the first row is taken into account}

\item{neighbours}{\code{numeric} value. Number of directions used in the Least Cost Path calculation. See Huber and Church (1985) for methodological considerations when choosing number of neighbours. Expected numeric values are 4, 8, 16, 32, 48 or a matrix object. Default is numeric value 16}

\item{path_ncells}{\code{numeric} value. Dimension of wide path matrix. Note that the value refers to the number of cells and not distance. See \code{\link{wide_path_matrix}} for example}
}
\value{
\code{SpatialPolygons} (sp package). The resultant object is the shortest wide path route (i.e. least cost) between origin and destination
}
\description{
Calculates a wide least cost path from an origin location to a destination location. Applies Dijkstra's algorithm. See details for more information
}
\details{
The calculation of a wide least cost path is inspired by Shirabe (2015).Instead of calculating a least cost path where the path width is assumed to be zero or negligible compared to the cell size, create_wide_lcp creates a wide least cost path where the path is calculated based on a cost surface that incorporates the total permeability of passage from adjacent cells

The algorithm proceeds as follows:

Each column of the supplied cost surface is summed, resulting in a raster with each cell representing the total permeability of passage from each adjacent neighbour (adjacent cells specificed when creating cost surface through the use of wide_path_matirx(). A transitionMatrix is created from this total permeability of passage raster, with the permeability of movement between cells based on the total permeability raster. That is, moving into each cell regardless of direction will incur the same cost.

Using this total permeability of passage cost surface, the least cost path can be calculated. This represents the least cost path between two locations based on the total permeability of passage cost surface that incorporates the summed permeability of passage. To visualise the wide least cost path, the least cost path is represented as a polygon with the width as supplied in the path_ncells argument.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))

n <- 3

slope_cs <- create_slope_cs(r, cost_function = 'tobler', neighbours = wide_path_matrix(n))

loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

loc2 = cbind(2667800, 6479400)
loc2 = sp::SpatialPoints(loc2)

lcps <- create_wide_lcp(cost_surface = slope_cs, origin = loc1,
destination = loc2, path_ncells = n)
}
\references{
Dijkstra, E. W. (1959). A note on two problems in connexion with graphs. Numerische Mathematik. 1: 269-271.

Shirabe, T. (2015). A method for finding a least-cost wide path in raster space. International Journal of Geographical Information Science 30, 1469-1485. \url{https://doi.org/10.1080/13658816.2015.1124435}
}
\author{
Joseph Lewis
}
